/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.Matrix4;
import icyllis.arc3d.core.Matrixc;
import icyllis.arc3d.core.Rect2f;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.Rect2i;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;

public class Matrix
implements Matrixc,
Cloneable {
    private static final int kAxisAligned_Mask = 16;
    private static final int kAxisAligned_Shift = 4;
    private static final int kOnlyPerspectiveValid_Mask = 64;
    private static final int kUnknown_Mask = 128;
    private static final Matrixc IDENTITY = new Matrix();
    protected float m11;
    protected float m12;
    protected float m14;
    protected float m21;
    protected float m22;
    protected float m24;
    protected float m41;
    protected float m42;
    protected float m44;
    private int mTypeMask;

    public Matrix() {
        this.m44 = 1.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.mTypeMask = 16;
    }

    public Matrix(@Nonnull Matrixc m) {
        m.store(this);
    }

    public Matrix(float scaleX, float shearY, float persp0, float shearX, float scaleY, float persp1, float transX, float transY, float persp2) {
        this.set(scaleX, shearY, persp0, shearX, scaleY, persp1, transX, transY, persp2);
    }

    @Nonnull
    public static Matrixc identity() {
        return IDENTITY;
    }

    @Nonnull
    public static Matrix makeTranslate(float dx, float dy) {
        Matrix matrix = new Matrix();
        matrix.setTranslate(dx, dy);
        return matrix;
    }

    @Nonnull
    public static Matrix makeScale(float sx, float sy) {
        Matrix matrix = new Matrix();
        matrix.setScale(sx, sy);
        return matrix;
    }

    @Override
    public float m11() {
        return this.m11;
    }

    @Override
    public float m12() {
        return this.m12;
    }

    @Override
    public float m14() {
        return this.m14;
    }

    @Override
    public float m21() {
        return this.m21;
    }

    @Override
    public float m22() {
        return this.m22;
    }

    @Override
    public float m24() {
        return this.m24;
    }

    @Override
    public float m41() {
        return this.m41;
    }

    @Override
    public float m42() {
        return this.m42;
    }

    @Override
    public float m44() {
        return this.m44;
    }

    @Override
    public float getScaleX() {
        return this.m11;
    }

    @Override
    public float getScaleY() {
        return this.m22;
    }

    @Override
    public float getShearY() {
        return this.m12;
    }

    @Override
    public float getShearX() {
        return this.m21;
    }

    @Override
    public float getTranslateX() {
        return this.m41;
    }

    @Override
    public float getTranslateY() {
        return this.m42;
    }

    @Override
    public float getPerspX() {
        return this.m14;
    }

    @Override
    public float getPerspY() {
        return this.m24;
    }

    @Override
    public int getType() {
        if ((this.mTypeMask & 0x80) != 0) {
            this.mTypeMask = this.computeTypeMask();
        }
        return this.mTypeMask & 0xF;
    }

    @Override
    public boolean isIdentity() {
        return this.getType() == 0;
    }

    @Override
    public boolean isScaleTranslate() {
        return (this.getType() & 0xFFFFFFFC) == 0;
    }

    @Override
    public boolean isTranslate() {
        return (this.getType() & 0xFFFFFFFE) == 0;
    }

    @Override
    public boolean isAxisAligned() {
        if ((this.mTypeMask & 0x80) != 0) {
            this.mTypeMask = this.computeTypeMask();
        }
        return (this.mTypeMask & 0x10) != 0;
    }

    @Override
    public boolean preservesRightAngles() {
        int mask = this.getType();
        if (mask <= 1) {
            return true;
        }
        if ((mask & 8) != 0) {
            return false;
        }
        assert ((mask & 6) != 0);
        float mx = this.m11;
        float my = this.m22;
        float sx = this.m21;
        float sy = this.m12;
        float det22 = mx * my - sx * sy;
        if (MathUtil.isApproxZero(det22)) {
            return false;
        }
        return MathUtil.isApproxZero(mx * sx + sy * my);
    }

    @Override
    public boolean hasPerspective() {
        if ((this.mTypeMask & 0x80) != 0 && (this.mTypeMask & 0x40) == 0) {
            this.mTypeMask = this.computePerspectiveTypeMask();
        }
        return (this.mTypeMask & 8) != 0;
    }

    @Override
    public boolean isSimilarity() {
        int mask = this.getType();
        if (mask <= 1) {
            return true;
        }
        if ((mask & 8) != 0) {
            return false;
        }
        float mx = this.m11;
        float my = this.m22;
        if ((mask & 4) == 0) {
            return !MathUtil.isApproxZero(mx) && MathUtil.isApproxEqual(Math.abs(mx), Math.abs(my));
        }
        float sx = this.m21;
        float sy = this.m12;
        float det22 = mx * my - sx * sy;
        if (MathUtil.isApproxZero(det22)) {
            return false;
        }
        return MathUtil.isApproxEqual(mx, my) && MathUtil.isApproxEqual(sx, -sy) || MathUtil.isApproxEqual(mx, -my) && MathUtil.isApproxEqual(sx, sy);
    }

    public void preConcat(@Nonnull Matrixc lhs) {
        float f44;
        float f42;
        float f41;
        float f24;
        float f22;
        float f21;
        float f14;
        float f12;
        float f11;
        int bMask = this.getType();
        if (bMask == 0) {
            this.set(lhs);
            return;
        }
        int aMask = lhs.getType();
        if (aMask == 0) {
            return;
        }
        if (((aMask | bMask) & 0xC) == 0) {
            this.setScaleTranslate(lhs.m11() * this.m11, lhs.m22() * this.m22, lhs.m41() * this.m11 + this.m41, lhs.m42() * this.m22 + this.m42);
            return;
        }
        if (((aMask | bMask) & 8) == 0) {
            f11 = lhs.m11() * this.m11 + lhs.m12() * this.m21;
            f12 = lhs.m11() * this.m12 + lhs.m12() * this.m22;
            f14 = 0.0f;
            f21 = lhs.m21() * this.m11 + lhs.m22() * this.m21;
            f22 = lhs.m21() * this.m12 + lhs.m22() * this.m22;
            f24 = 0.0f;
            f41 = lhs.m41() * this.m11 + lhs.m42() * this.m21 + this.m41;
            f42 = lhs.m41() * this.m12 + lhs.m42() * this.m22 + this.m42;
            f44 = 1.0f;
            this.mTypeMask = 192;
        } else {
            f11 = lhs.m11() * this.m11 + lhs.m12() * this.m21 + lhs.m14() * this.m41;
            f12 = lhs.m11() * this.m12 + lhs.m12() * this.m22 + lhs.m14() * this.m42;
            f14 = lhs.m11() * this.m14 + lhs.m12() * this.m24 + lhs.m14() * this.m44;
            f21 = lhs.m21() * this.m11 + lhs.m22() * this.m21 + lhs.m24() * this.m41;
            f22 = lhs.m21() * this.m12 + lhs.m22() * this.m22 + lhs.m24() * this.m42;
            f24 = lhs.m21() * this.m14 + lhs.m22() * this.m24 + lhs.m24() * this.m44;
            f41 = lhs.m41() * this.m11 + lhs.m42() * this.m21 + lhs.m44() * this.m41;
            f42 = lhs.m41() * this.m12 + lhs.m42() * this.m22 + lhs.m44() * this.m42;
            f44 = lhs.m41() * this.m14 + lhs.m42() * this.m24 + lhs.m44() * this.m44;
            this.mTypeMask = 128;
        }
        this.m11 = f11;
        this.m12 = f12;
        this.m14 = f14;
        this.m21 = f21;
        this.m22 = f22;
        this.m24 = f24;
        this.m41 = f41;
        this.m42 = f42;
        this.m44 = f44;
    }

    public void postConcat(@Nonnull Matrixc rhs) {
        float f44;
        float f42;
        float f41;
        float f24;
        float f22;
        float f21;
        float f14;
        float f12;
        float f11;
        int aMask = this.getType();
        if (aMask == 0) {
            this.set(rhs);
            return;
        }
        int bMask = rhs.getType();
        if (bMask == 0) {
            return;
        }
        if (((aMask | bMask) & 0xC) == 0) {
            this.setScaleTranslate(this.m11 * rhs.m11(), this.m22 * rhs.m22(), this.m41 * rhs.m11() + rhs.m41(), this.m42 * rhs.m22() + rhs.m42());
            return;
        }
        if (((aMask | bMask) & 8) == 0) {
            f11 = this.m11 * rhs.m11() + this.m12 * rhs.m21();
            f12 = this.m11 * rhs.m12() + this.m12 * rhs.m22();
            f14 = 0.0f;
            f21 = this.m21 * rhs.m11() + this.m22 * rhs.m21();
            f22 = this.m21 * rhs.m12() + this.m22 * rhs.m22();
            f24 = 0.0f;
            f41 = this.m41 * rhs.m11() + this.m42 * rhs.m21() + rhs.m41();
            f42 = this.m41 * rhs.m12() + this.m42 * rhs.m22() + rhs.m42();
            f44 = 1.0f;
            this.mTypeMask = 192;
        } else {
            f11 = this.m11 * rhs.m11() + this.m12 * rhs.m21() + this.m14 * rhs.m41();
            f12 = this.m11 * rhs.m12() + this.m12 * rhs.m22() + this.m14 * rhs.m42();
            f14 = this.m11 * rhs.m14() + this.m12 * rhs.m24() + this.m14 * rhs.m44();
            f21 = this.m21 * rhs.m11() + this.m22 * rhs.m21() + this.m24 * rhs.m41();
            f22 = this.m21 * rhs.m12() + this.m22 * rhs.m22() + this.m24 * rhs.m42();
            f24 = this.m21 * rhs.m14() + this.m22 * rhs.m24() + this.m24 * rhs.m44();
            f41 = this.m41 * rhs.m11() + this.m42 * rhs.m21() + this.m44 * rhs.m41();
            f42 = this.m41 * rhs.m12() + this.m42 * rhs.m22() + this.m44 * rhs.m42();
            f44 = this.m41 * rhs.m14() + this.m42 * rhs.m24() + this.m44 * rhs.m44();
            this.mTypeMask = 128;
        }
        this.m11 = f11;
        this.m12 = f12;
        this.m14 = f14;
        this.m21 = f21;
        this.m22 = f22;
        this.m24 = f24;
        this.m41 = f41;
        this.m42 = f42;
        this.m44 = f44;
    }

    public void setIdentity() {
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m14 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m24 = 0.0f;
        this.m41 = 0.0f;
        this.m42 = 0.0f;
        this.m44 = 1.0f;
        this.mTypeMask = 16;
    }

    public void setScaleTranslate(float sx, float sy, float tx, float ty) {
        this.m11 = sx;
        this.m12 = 0.0f;
        this.m14 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = sy;
        this.m24 = 0.0f;
        this.m41 = tx;
        this.m42 = ty;
        this.m44 = 1.0f;
        int mask = 0;
        if (sx != 1.0f || sy != 1.0f) {
            mask |= 2;
        }
        if (tx != 0.0f || ty != 0.0f) {
            mask |= 1;
        }
        if (sx != 0.0f && sy != 0.0f) {
            mask |= 0x10;
        }
        this.mTypeMask = mask;
    }

    public void m11(float scaleX) {
        this.m11 = scaleX;
        this.mTypeMask = 128;
    }

    public void m12(float shearY) {
        this.m12 = shearY;
        this.mTypeMask = 128;
    }

    public void m14(float persp0) {
        this.m14 = persp0;
        this.mTypeMask = 128;
    }

    public void m21(float shearX) {
        this.m21 = shearX;
        this.mTypeMask = 128;
    }

    public void m22(float scaleY) {
        this.m22 = scaleY;
        this.mTypeMask = 128;
    }

    public void m24(float persp1) {
        this.m24 = persp1;
        this.mTypeMask = 128;
    }

    public void m41(float transX) {
        this.m41 = transX;
        this.mTypeMask = 128;
    }

    public void m42(float transY) {
        this.m42 = transY;
        this.mTypeMask = 128;
    }

    public void m44(float persp2) {
        this.m44 = persp2;
        this.mTypeMask = 128;
    }

    public void setScaleX(float scaleX) {
        this.m11 = scaleX;
        this.mTypeMask = 128;
    }

    public void setScaleY(float scaleY) {
        this.m22 = scaleY;
        this.mTypeMask = 128;
    }

    public void setShearY(float shearY) {
        this.m12 = shearY;
        this.mTypeMask = 128;
    }

    public void setShearX(float shearX) {
        this.m21 = shearX;
        this.mTypeMask = 128;
    }

    public void setTranslateX(float transX) {
        this.m41 = transX;
        this.mTypeMask = 128;
    }

    public void setTranslateY(float transY) {
        this.m42 = transY;
        this.mTypeMask = 128;
    }

    public void setPerspY(float perspY) {
        this.m24 = perspY;
        this.mTypeMask = 128;
    }

    public void setPerspX(float perspX) {
        this.m14 = perspX;
        this.mTypeMask = 128;
    }

    public void set(@Nonnull Matrixc m) {
        m.store(this);
    }

    public void set(float scaleX, float shearY, float persp0, float shearX, float scaleY, float persp1, float transX, float transY, float persp2) {
        this.m11 = scaleX;
        this.m12 = shearY;
        this.m14 = persp0;
        this.m21 = shearX;
        this.m22 = scaleY;
        this.m24 = persp1;
        this.m41 = transX;
        this.m42 = transY;
        this.m44 = persp2;
        this.mTypeMask = 128;
    }

    public void set(@Nonnull float[] a) {
        this.m11 = a[0];
        this.m12 = a[1];
        this.m14 = a[2];
        this.m21 = a[3];
        this.m22 = a[4];
        this.m24 = a[5];
        this.m41 = a[6];
        this.m42 = a[7];
        this.m44 = a[8];
        this.mTypeMask = 128;
    }

    public void set(@Nonnull float[] a, int offset) {
        this.m11 = a[offset];
        this.m12 = a[offset + 1];
        this.m14 = a[offset + 2];
        this.m21 = a[offset + 3];
        this.m22 = a[offset + 4];
        this.m24 = a[offset + 5];
        this.m41 = a[offset + 6];
        this.m42 = a[offset + 7];
        this.m44 = a[offset + 8];
        this.mTypeMask = 128;
    }

    public void set(@Nonnull ByteBuffer a) {
        int offset = a.position();
        this.m11 = a.getFloat(offset);
        this.m12 = a.getFloat(offset + 4);
        this.m14 = a.getFloat(offset + 8);
        this.m21 = a.getFloat(offset + 12);
        this.m22 = a.getFloat(offset + 16);
        this.m24 = a.getFloat(offset + 20);
        this.m41 = a.getFloat(offset + 24);
        this.m42 = a.getFloat(offset + 28);
        this.m44 = a.getFloat(offset + 32);
        this.mTypeMask = 128;
    }

    public void set(@Nonnull FloatBuffer a) {
        int offset = a.position();
        this.m11 = a.get(offset);
        this.m12 = a.get(offset + 1);
        this.m14 = a.get(offset + 2);
        this.m21 = a.get(offset + 3);
        this.m22 = a.get(offset + 4);
        this.m24 = a.get(offset + 5);
        this.m41 = a.get(offset + 6);
        this.m42 = a.get(offset + 7);
        this.m44 = a.get(offset + 8);
        this.mTypeMask = 128;
    }

    public void set(long p) {
        this.m11 = MemoryUtil.memGetFloat((long)p);
        this.m12 = MemoryUtil.memGetFloat((long)(p + 4L));
        this.m14 = MemoryUtil.memGetFloat((long)(p + 8L));
        this.m21 = MemoryUtil.memGetFloat((long)(p + 12L));
        this.m22 = MemoryUtil.memGetFloat((long)(p + 16L));
        this.m24 = MemoryUtil.memGetFloat((long)(p + 20L));
        this.m41 = MemoryUtil.memGetFloat((long)(p + 24L));
        this.m42 = MemoryUtil.memGetFloat((long)(p + 28L));
        this.m44 = MemoryUtil.memGetFloat((long)(p + 32L));
        this.mTypeMask = 128;
    }

    @Override
    public void store(@Nonnull Matrix dst) {
        dst.m11 = this.m11;
        dst.m12 = this.m12;
        dst.m14 = this.m14;
        dst.m21 = this.m21;
        dst.m22 = this.m22;
        dst.m24 = this.m24;
        dst.m41 = this.m41;
        dst.m42 = this.m42;
        dst.m44 = this.m44;
        dst.mTypeMask = this.mTypeMask;
    }

    @Override
    public void store(@Nonnull float[] a) {
        a[0] = this.m11;
        a[1] = this.m12;
        a[2] = this.m14;
        a[3] = this.m21;
        a[4] = this.m22;
        a[5] = this.m24;
        a[6] = this.m41;
        a[7] = this.m42;
        a[8] = this.m44;
    }

    @Override
    public void store(@Nonnull float[] a, int offset) {
        a[offset] = this.m11;
        a[offset + 1] = this.m12;
        a[offset + 2] = this.m14;
        a[offset + 3] = this.m21;
        a[offset + 4] = this.m22;
        a[offset + 5] = this.m24;
        a[offset + 6] = this.m41;
        a[offset + 7] = this.m42;
        a[offset + 8] = this.m44;
    }

    @Override
    public void store(@Nonnull ByteBuffer a) {
        int offset = a.position();
        a.putFloat(offset, this.m11);
        a.putFloat(offset + 4, this.m12);
        a.putFloat(offset + 8, this.m14);
        a.putFloat(offset + 12, this.m21);
        a.putFloat(offset + 16, this.m22);
        a.putFloat(offset + 20, this.m24);
        a.putFloat(offset + 24, this.m41);
        a.putFloat(offset + 28, this.m42);
        a.putFloat(offset + 32, this.m44);
    }

    @Override
    public void storeAligned(@Nonnull ByteBuffer a) {
        int offset = a.position();
        a.putFloat(offset, this.m11);
        a.putFloat(offset + 4, this.m12);
        a.putFloat(offset + 8, this.m14);
        a.putFloat(offset + 16, this.m21);
        a.putFloat(offset + 20, this.m22);
        a.putFloat(offset + 24, this.m24);
        a.putFloat(offset + 32, this.m41);
        a.putFloat(offset + 36, this.m42);
        a.putFloat(offset + 40, this.m44);
    }

    @Override
    public void store(@Nonnull FloatBuffer a) {
        int offset = a.position();
        a.put(offset, this.m11);
        a.put(offset + 1, this.m12);
        a.put(offset + 2, this.m14);
        a.put(offset + 3, this.m21);
        a.put(offset + 4, this.m22);
        a.put(offset + 5, this.m24);
        a.put(offset + 6, this.m41);
        a.put(offset + 7, this.m42);
        a.put(offset + 8, this.m44);
    }

    @Override
    public void storeAligned(@Nonnull FloatBuffer a) {
        int offset = a.position();
        a.put(offset, this.m11);
        a.put(offset + 1, this.m12);
        a.put(offset + 2, this.m14);
        a.put(offset + 4, this.m21);
        a.put(offset + 5, this.m22);
        a.put(offset + 6, this.m24);
        a.put(offset + 8, this.m41);
        a.put(offset + 9, this.m42);
        a.put(offset + 10, this.m44);
    }

    @Override
    public void store(long p) {
        MemoryUtil.memPutFloat((long)p, (float)this.m11);
        MemoryUtil.memPutFloat((long)(p + 4L), (float)this.m12);
        MemoryUtil.memPutFloat((long)(p + 8L), (float)this.m14);
        MemoryUtil.memPutFloat((long)(p + 12L), (float)this.m21);
        MemoryUtil.memPutFloat((long)(p + 16L), (float)this.m22);
        MemoryUtil.memPutFloat((long)(p + 20L), (float)this.m24);
        MemoryUtil.memPutFloat((long)(p + 24L), (float)this.m41);
        MemoryUtil.memPutFloat((long)(p + 28L), (float)this.m42);
        MemoryUtil.memPutFloat((long)(p + 32L), (float)this.m44);
    }

    @Override
    public void storeAligned(long p) {
        MemoryUtil.memPutFloat((long)p, (float)this.m11);
        MemoryUtil.memPutFloat((long)(p + 4L), (float)this.m12);
        MemoryUtil.memPutFloat((long)(p + 8L), (float)this.m14);
        MemoryUtil.memPutFloat((long)(p + 16L), (float)this.m21);
        MemoryUtil.memPutFloat((long)(p + 20L), (float)this.m22);
        MemoryUtil.memPutFloat((long)(p + 24L), (float)this.m24);
        MemoryUtil.memPutFloat((long)(p + 32L), (float)this.m41);
        MemoryUtil.memPutFloat((long)(p + 36L), (float)this.m42);
        MemoryUtil.memPutFloat((long)(p + 40L), (float)this.m44);
    }

    @Override
    public void toMatrix4(@Nonnull Matrix4 dest) {
        dest.m11 = this.m11;
        dest.m12 = this.m12;
        dest.m13 = 0.0f;
        dest.m14 = this.m14;
        dest.m21 = this.m21;
        dest.m22 = this.m22;
        dest.m23 = 0.0f;
        dest.m24 = this.m24;
        dest.m31 = 0.0f;
        dest.m32 = 0.0f;
        dest.m33 = 1.0f;
        dest.m34 = 0.0f;
        dest.m41 = this.m41;
        dest.m42 = this.m42;
        dest.m43 = 0.0f;
        dest.m44 = this.m44;
    }

    @Override
    @Nonnull
    public Matrix4 toMatrix4() {
        Matrix4 m = new Matrix4();
        this.toMatrix4(m);
        return m;
    }

    public float determinant() {
        double det;
        if (this.hasPerspective()) {
            double a = (double)this.m11 * (double)this.m22 - (double)this.m12 * (double)this.m21;
            double b = (double)this.m14 * (double)this.m21 - (double)this.m11 * (double)this.m24;
            double c = (double)this.m12 * (double)this.m24 - (double)this.m14 * (double)this.m22;
            det = a * (double)this.m44 + b * (double)this.m42 + c * (double)this.m41;
        } else {
            det = (double)this.m11 * (double)this.m22 - (double)this.m12 * (double)this.m21;
        }
        return (float)det;
    }

    public float trace() {
        return this.m11 + this.m22 + this.m44;
    }

    @CheckReturnValue
    public boolean invert() {
        return this.invert(this);
    }

    @Override
    public boolean invert(@Nullable Matrix dest) {
        int mask = this.getType();
        if (mask == 0) {
            if (dest != null) {
                dest.setIdentity();
            }
            return true;
        }
        if ((mask & 0xFFFFFFFC) == 0) {
            return this.invertScaleTranslate(mask, dest);
        }
        if ((mask & 8) != 0) {
            return this.invertPerspective(dest);
        }
        return this.invertAffine(dest);
    }

    private boolean invertScaleTranslate(int mask, Matrix dest) {
        if ((mask & 2) != 0) {
            float invX = 1.0f / this.m11;
            float invY = 1.0f / this.m22;
            if (!Float.isFinite(invX) || !Float.isFinite(invY)) {
                return false;
            }
            float f41 = (float)((double)(-this.m41) / (double)this.m11);
            float f42 = (float)((double)(-this.m42) / (double)this.m22);
            if (!Float.isFinite(f41) || !Float.isFinite(f42)) {
                return false;
            }
            if (dest != null) {
                dest.m11 = invX;
                dest.m12 = 0.0f;
                dest.m14 = 0.0f;
                dest.m21 = 0.0f;
                dest.m22 = invY;
                dest.m24 = 0.0f;
                dest.m41 = f41;
                dest.m42 = f42;
                dest.m44 = 1.0f;
                dest.mTypeMask = mask | 0x10;
            }
        } else {
            if (!Float.isFinite(this.m41) || !Float.isFinite(this.m42)) {
                return false;
            }
            if (dest != null) {
                dest.setTranslate(-this.m41, -this.m42);
            }
        }
        return true;
    }

    private boolean invertPerspective(Matrix dest) {
        double a = (double)this.m11 * (double)this.m22 - (double)this.m12 * (double)this.m21;
        double b = (double)this.m14 * (double)this.m21 - (double)this.m11 * (double)this.m24;
        double c = (double)this.m12 * (double)this.m24 - (double)this.m14 * (double)this.m22;
        double det = a * (double)this.m44 + b * (double)this.m42 + c * (double)this.m41;
        if (MathUtil.isApproxZero((float)det, 1.0E-15f)) {
            return false;
        }
        float f11 = (float)((double)(this.m22 * this.m44 - this.m42 * this.m24) * (det = 1.0 / det));
        float f12 = (float)((double)(this.m42 * this.m14 - this.m12 * this.m44) * det);
        float f14 = (float)(c * det);
        float f21 = (float)((double)(this.m41 * this.m24 - this.m21 * this.m44) * det);
        float f22 = (float)((double)(this.m11 * this.m44 - this.m41 * this.m14) * det);
        float f24 = (float)(b * det);
        float f41 = (float)((double)(this.m21 * this.m42 - this.m41 * this.m22) * det);
        float f42 = (float)((double)(this.m41 * this.m12 - this.m11 * this.m42) * det);
        float f44 = (float)(a * det);
        if (!MathUtil.isFinite(f11, f12, f14, f21, f22, f24, f41, f42, f44)) {
            return false;
        }
        if (dest != null) {
            dest.m11 = f11;
            dest.m12 = f12;
            dest.m14 = f14;
            dest.m21 = f21;
            dest.m22 = f22;
            dest.m24 = f24;
            dest.m41 = f41;
            dest.m42 = f42;
            dest.m44 = f44;
            dest.mTypeMask = this.mTypeMask;
        }
        return true;
    }

    private boolean invertAffine(Matrix dest) {
        double det = (double)this.m11 * (double)this.m22 - (double)this.m12 * (double)this.m21;
        if (MathUtil.isApproxZero((float)det, 1.0E-15f)) {
            return false;
        }
        float f11 = (float)((double)this.m22 * (det = 1.0 / det));
        float f12 = (float)((double)(-this.m12) * det);
        float f21 = (float)((double)(-this.m21) * det);
        float f22 = (float)((double)this.m11 * det);
        float f41 = (float)((double)(this.m21 * this.m42 - this.m41 * this.m22) * det);
        float f42 = (float)((double)(this.m41 * this.m12 - this.m11 * this.m42) * det);
        if (!MathUtil.isFinite(f11, f12, f21, f22, f41, f42)) {
            return false;
        }
        if (dest != null) {
            dest.m11 = f11;
            dest.m12 = f12;
            dest.m14 = 0.0f;
            dest.m21 = f21;
            dest.m22 = f22;
            dest.m24 = 0.0f;
            dest.m41 = f41;
            dest.m42 = f42;
            dest.m44 = 1.0f;
            dest.mTypeMask = this.mTypeMask;
        }
        return true;
    }

    public void preTranslate(float dx, float dy) {
        int mask = this.getType();
        if ((mask & 8) != 0) {
            this.m41 += dx * this.m11 + dy * this.m21;
            this.m42 += dx * this.m12 + dy * this.m22;
            this.m44 += dx * this.m14 + dy * this.m24;
            this.mTypeMask = 128;
            return;
        }
        if (mask <= 1) {
            this.m41 += dx;
            this.m42 += dy;
        } else {
            this.m41 += dx * this.m11 + dy * this.m21;
            this.m42 += dx * this.m12 + dy * this.m22;
        }
        this.mTypeMask = this.m41 != 0.0f || this.m42 != 0.0f ? (this.mTypeMask |= 1) : (this.mTypeMask &= 0xFFFFFFFE);
    }

    public void postTranslate(float dx, float dy) {
        int mask = this.getType();
        if ((mask & 8) != 0) {
            this.m11 += dx * this.m14;
            this.m12 += dy * this.m14;
            this.m21 += dx * this.m24;
            this.m22 += dy * this.m24;
            this.m41 += dx * this.m44;
            this.m42 += dy * this.m44;
            this.mTypeMask = 128;
            return;
        }
        this.m41 += dx;
        this.m42 += dy;
        this.mTypeMask = this.m41 != 0.0f || this.m42 != 0.0f ? (this.mTypeMask |= 1) : (this.mTypeMask &= 0xFFFFFFFE);
    }

    public void setTranslate(float dx, float dy) {
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m14 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m24 = 0.0f;
        this.m41 = dx;
        this.m42 = dy;
        this.m44 = 1.0f;
        this.mTypeMask = dx != 0.0f || dy != 0.0f ? 17 : 16;
    }

    public void preScale(float sx, float sy) {
        if (sx == 1.0f && sy == 1.0f) {
            return;
        }
        int mask = this.getType();
        if (mask == 0) {
            this.setScale(sx, sy);
            return;
        }
        if ((mask & 0xC) == 0) {
            this.setScaleTranslate(sx * this.m11, sy * this.m22, this.m41, this.m42);
            return;
        }
        this.m11 *= sx;
        this.m12 *= sx;
        this.m21 *= sy;
        this.m22 *= sy;
        if ((mask & 8) == 0) {
            this.mTypeMask = 192;
        } else {
            this.m14 *= sx;
            this.m24 *= sy;
            this.mTypeMask = 128;
        }
    }

    public void postScale(float sx, float sy) {
        if (sx == 1.0f && sy == 1.0f) {
            return;
        }
        int mask = this.getType();
        if (mask == 0) {
            this.setScale(sx, sy);
            return;
        }
        if ((mask & 0xC) == 0) {
            this.setScaleTranslate(this.m11 * sx, this.m22 * sy, this.m41 * sx, this.m42 * sy);
            return;
        }
        this.m11 *= sx;
        this.m21 *= sx;
        this.m41 *= sx;
        this.m12 *= sy;
        this.m22 *= sy;
        this.m42 *= sy;
        this.mTypeMask = (mask & 8) == 0 ? 192 : 128;
    }

    public void setScale(float sx, float sy) {
        this.m11 = sx;
        this.m12 = 0.0f;
        this.m14 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = sy;
        this.m24 = 0.0f;
        this.m41 = 0.0f;
        this.m42 = 0.0f;
        this.m44 = 1.0f;
        this.mTypeMask = sx == 1.0f && sy == 1.0f ? 16 : 2 | (sx != 0.0f && sy != 0.0f ? 16 : 0);
    }

    public void setScale(float sx, float sy, float px, float py) {
        if (sx == 1.0f && sy == 1.0f) {
            this.setIdentity();
        } else {
            this.setScaleTranslate(sx, sy, px - sx * px, py - sy * py);
        }
    }

    public void preRotate(float angle) {
        if (angle == 0.0f) {
            return;
        }
        int mask = this.getType();
        if (mask == 0) {
            this.setRotate(angle);
            return;
        }
        double s = Math.sin(angle);
        double c = Math.cos(angle);
        double f11 = c * (double)this.m11 + s * (double)this.m21;
        double f12 = c * (double)this.m12 + s * (double)this.m22;
        double f14 = c * (double)this.m14 + s * (double)this.m24;
        this.m21 = (float)(c * (double)this.m21 - s * (double)this.m11);
        this.m22 = (float)(c * (double)this.m22 - s * (double)this.m12);
        this.m24 = (float)(c * (double)this.m24 - s * (double)this.m14);
        this.m11 = (float)f11;
        this.m12 = (float)f12;
        this.m14 = (float)f14;
        this.mTypeMask = (mask & 8) == 0 ? 192 : 128;
    }

    public void postRotate(float angle) {
        if (angle == 0.0f) {
            return;
        }
        int mask = this.getType();
        if (mask == 0) {
            this.setRotate(angle);
            return;
        }
        double s = Math.sin(angle);
        double c = Math.cos(angle);
        double f12 = c * (double)this.m12 + s * (double)this.m11;
        double f22 = c * (double)this.m22 + s * (double)this.m21;
        double f42 = c * (double)this.m42 + s * (double)this.m41;
        this.m11 = (float)(c * (double)this.m11 - s * (double)this.m12);
        this.m21 = (float)(c * (double)this.m21 - s * (double)this.m22);
        this.m41 = (float)(c * (double)this.m41 - s * (double)this.m42);
        this.m12 = (float)f12;
        this.m22 = (float)f22;
        this.m42 = (float)f42;
        this.mTypeMask = (mask & 8) == 0 ? 192 : 128;
    }

    public void setRotate(float angle) {
        if (angle == 0.0f) {
            this.setIdentity();
        } else {
            float s = (float)Math.sin(angle);
            float c = (float)Math.cos(angle);
            this.setSinCos(MathUtil.isApproxZero(s) ? 0.0f : s, MathUtil.isApproxZero(c) ? 0.0f : c);
        }
    }

    public void setRotate(float angle, float px, float py) {
        if (angle == 0.0f) {
            this.setIdentity();
        } else {
            float s = (float)Math.sin(angle);
            float c = (float)Math.cos(angle);
            this.setSinCos(MathUtil.isApproxZero(s) ? 0.0f : s, MathUtil.isApproxZero(c) ? 0.0f : c, px, py);
        }
    }

    public void setSinCos(float sin, float cos) {
        this.m11 = cos;
        this.m12 = sin;
        this.m14 = 0.0f;
        this.m21 = -sin;
        this.m22 = cos;
        this.m24 = 0.0f;
        this.m41 = 0.0f;
        this.m42 = 0.0f;
        this.m44 = 1.0f;
        this.mTypeMask = 192;
    }

    public void setSinCos(float sin, float cos, float px, float py) {
        double omc = 1.0f - cos;
        this.m11 = cos;
        this.m12 = sin;
        this.m14 = 0.0f;
        this.m21 = -sin;
        this.m22 = cos;
        this.m24 = 0.0f;
        this.m41 = (float)(omc * (double)px + (double)(sin * py));
        this.m42 = (float)(omc * (double)py - (double)(sin * px));
        this.m44 = 1.0f;
        this.mTypeMask = 192;
    }

    public void preShear(float sx, float sy) {
        float f24;
        float f22;
        float f21;
        float f14;
        float f12;
        float f11;
        int mask = this.getType();
        if (mask == 0) {
            this.setShear(sx, sy);
            return;
        }
        if ((mask & 8) == 0) {
            f11 = this.m11 + sy * this.m21;
            f12 = this.m12 + sy * this.m22;
            f14 = 0.0f;
            f21 = sx * this.m11 + this.m21;
            f22 = sx * this.m12 + this.m22;
            f24 = 0.0f;
            this.mTypeMask = 192;
        } else {
            f11 = this.m11 + sy * this.m21;
            f12 = this.m12 + sy * this.m22;
            f14 = this.m14 + sy * this.m24;
            f21 = sx * this.m11 + this.m21;
            f22 = sx * this.m12 + this.m22;
            f24 = sx * this.m14 + this.m24;
            this.mTypeMask = 128;
        }
        this.m11 = f11;
        this.m12 = f12;
        this.m14 = f14;
        this.m21 = f21;
        this.m22 = f22;
        this.m24 = f24;
    }

    public void postShear(float sx, float sy) {
        float f42;
        float f41;
        float f22;
        float f21;
        float f12;
        float f11;
        int mask = this.getType();
        if (mask == 0) {
            this.setShear(sx, sy);
            return;
        }
        if ((mask & 8) == 0) {
            f11 = this.m11 + this.m12 * sx;
            f12 = this.m11 * sy + this.m12;
            f21 = this.m21 + this.m22 * sx;
            f22 = this.m21 * sy + this.m22;
            f41 = this.m41 + this.m42 * sx;
            f42 = this.m41 * sy + this.m42;
            this.mTypeMask = 192;
        } else {
            f11 = this.m11 + this.m12 * sx;
            f12 = this.m11 * sy + this.m12;
            f21 = this.m21 + this.m22 * sx;
            f22 = this.m21 * sy + this.m22;
            f41 = this.m41 + this.m42 * sx;
            f42 = this.m41 * sy + this.m42;
            this.mTypeMask = 128;
        }
        this.m11 = f11;
        this.m12 = f12;
        this.m21 = f21;
        this.m22 = f22;
        this.m41 = f41;
        this.m42 = f42;
    }

    public void setShear(float sx, float sy) {
        this.m11 = 1.0f;
        this.m12 = sy;
        this.m14 = 0.0f;
        this.m21 = sx;
        this.m22 = 1.0f;
        this.m24 = 0.0f;
        this.m41 = 0.0f;
        this.m42 = 0.0f;
        this.m44 = 1.0f;
        this.mTypeMask = 192;
    }

    public void setShear(float sx, float sy, float px, float py) {
        this.m11 = 1.0f;
        this.m12 = sy;
        this.m14 = 0.0f;
        this.m21 = sx;
        this.m22 = 1.0f;
        this.m24 = 0.0f;
        this.m41 = -sx * py;
        this.m42 = -sy * px;
        this.m44 = 1.0f;
        this.mTypeMask = 192;
    }

    @Override
    public boolean mapRect(@Nonnull Rect2fc src, @Nonnull Rect2f dst) {
        int typeMask = this.getType();
        float left = src.left();
        float top = src.top();
        float right = src.right();
        float bottom = src.bottom();
        if (typeMask <= 1) {
            dst.mLeft = left + this.m41;
            dst.mTop = top + this.m42;
            dst.mRight = right + this.m41;
            dst.mBottom = bottom + this.m42;
            return true;
        }
        if ((typeMask & 0xFFFFFFFC) == 0) {
            float x1 = left * this.m11 + this.m41;
            float y1 = top * this.m22 + this.m42;
            float x2 = right * this.m11 + this.m41;
            float y2 = bottom * this.m22 + this.m42;
            dst.mLeft = Math.min(x1, x2);
            dst.mTop = Math.min(y1, y2);
            dst.mRight = Math.max(x1, x2);
            dst.mBottom = Math.max(y1, y2);
            return true;
        }
        float x1 = this.m11 * left + this.m21 * top + this.m41;
        float y1 = this.m12 * left + this.m22 * top + this.m42;
        float x2 = this.m11 * right + this.m21 * top + this.m41;
        float y2 = this.m12 * right + this.m22 * top + this.m42;
        float x3 = this.m11 * left + this.m21 * bottom + this.m41;
        float y3 = this.m12 * left + this.m22 * bottom + this.m42;
        float x4 = this.m11 * right + this.m21 * bottom + this.m41;
        float y4 = this.m12 * right + this.m22 * bottom + this.m42;
        if ((typeMask & 8) != 0) {
            float w = 1.0f / (this.m14 * left + this.m24 * top + this.m44);
            x1 *= w;
            y1 *= w;
            w = 1.0f / (this.m14 * right + this.m24 * top + this.m44);
            x2 *= w;
            y2 *= w;
            w = 1.0f / (this.m14 * left + this.m24 * bottom + this.m44);
            x3 *= w;
            y3 *= w;
            w = 1.0f / (this.m14 * right + this.m24 * bottom + this.m44);
            x4 *= w;
            y4 *= w;
        }
        dst.mLeft = MathUtil.min(x1, x2, x3, x4);
        dst.mTop = MathUtil.min(y1, y2, y3, y4);
        dst.mRight = MathUtil.max(x1, x2, x3, x4);
        dst.mBottom = MathUtil.max(y1, y2, y3, y4);
        return (typeMask & 0x10) != 0;
    }

    @Override
    public void mapRect(float left, float top, float right, float bottom, @Nonnull Rect2i dst) {
        int typeMask = this.getType();
        if (typeMask <= 1) {
            dst.mLeft = Math.round(left + this.m41);
            dst.mTop = Math.round(top + this.m42);
            dst.mRight = Math.round(right + this.m41);
            dst.mBottom = Math.round(bottom + this.m42);
            return;
        }
        if ((typeMask & 0xFFFFFFFC) == 0) {
            dst.mLeft = Math.round(left * this.m11 + this.m41);
            dst.mTop = Math.round(top * this.m22 + this.m42);
            dst.mRight = Math.round(right * this.m11 + this.m41);
            dst.mBottom = Math.round(bottom * this.m22 + this.m42);
            dst.sort();
            return;
        }
        float x1 = this.m11 * left + this.m21 * top + this.m41;
        float y1 = this.m12 * left + this.m22 * top + this.m42;
        float x2 = this.m11 * right + this.m21 * top + this.m41;
        float y2 = this.m12 * right + this.m22 * top + this.m42;
        float x3 = this.m11 * left + this.m21 * bottom + this.m41;
        float y3 = this.m12 * left + this.m22 * bottom + this.m42;
        float x4 = this.m11 * right + this.m21 * bottom + this.m41;
        float y4 = this.m12 * right + this.m22 * bottom + this.m42;
        if ((typeMask & 8) != 0) {
            float w = 1.0f / (this.m14 * left + this.m24 * top + this.m44);
            x1 *= w;
            y1 *= w;
            w = 1.0f / (this.m14 * right + this.m24 * top + this.m44);
            x2 *= w;
            y2 *= w;
            w = 1.0f / (this.m14 * left + this.m24 * bottom + this.m44);
            x3 *= w;
            y3 *= w;
            w = 1.0f / (this.m14 * right + this.m24 * bottom + this.m44);
            x4 *= w;
            y4 *= w;
        }
        dst.mLeft = Math.round(MathUtil.min(x1, x2, x3, x4));
        dst.mTop = Math.round(MathUtil.min(y1, y2, y3, y4));
        dst.mRight = Math.round(MathUtil.max(x1, x2, x3, x4));
        dst.mBottom = Math.round(MathUtil.max(y1, y2, y3, y4));
    }

    @Override
    public void mapRectOut(float left, float top, float right, float bottom, @Nonnull Rect2i dst) {
        int typeMask = this.getType();
        if (typeMask <= 1) {
            dst.mLeft = (int)Math.floor(left + this.m41);
            dst.mTop = (int)Math.floor(top + this.m42);
            dst.mRight = (int)Math.ceil(right + this.m41);
            dst.mBottom = (int)Math.ceil(bottom + this.m42);
            return;
        }
        if ((typeMask & 0xFFFFFFFC) == 0) {
            dst.mLeft = (int)Math.floor(left * this.m11 + this.m41);
            dst.mTop = (int)Math.floor(top * this.m22 + this.m42);
            dst.mRight = (int)Math.ceil(right * this.m11 + this.m41);
            dst.mBottom = (int)Math.ceil(bottom * this.m22 + this.m42);
            dst.sort();
            return;
        }
        float x1 = this.m11 * left + this.m21 * top + this.m41;
        float y1 = this.m12 * left + this.m22 * top + this.m42;
        float x2 = this.m11 * right + this.m21 * top + this.m41;
        float y2 = this.m12 * right + this.m22 * top + this.m42;
        float x3 = this.m11 * left + this.m21 * bottom + this.m41;
        float y3 = this.m12 * left + this.m22 * bottom + this.m42;
        float x4 = this.m11 * right + this.m21 * bottom + this.m41;
        float y4 = this.m12 * right + this.m22 * bottom + this.m42;
        if ((typeMask & 8) != 0) {
            float w = 1.0f / (this.m14 * left + this.m24 * top + this.m44);
            x1 *= w;
            y1 *= w;
            w = 1.0f / (this.m14 * right + this.m24 * top + this.m44);
            x2 *= w;
            y2 *= w;
            w = 1.0f / (this.m14 * left + this.m24 * bottom + this.m44);
            x3 *= w;
            y3 *= w;
            w = 1.0f / (this.m14 * right + this.m24 * bottom + this.m44);
            x4 *= w;
            y4 *= w;
        }
        dst.mLeft = (int)Math.floor(MathUtil.min(x1, x2, x3, x4));
        dst.mTop = (int)Math.floor(MathUtil.min(y1, y2, y3, y4));
        dst.mRight = (int)Math.ceil(MathUtil.max(x1, x2, x3, x4));
        dst.mBottom = (int)Math.ceil(MathUtil.max(y1, y2, y3, y4));
    }

    @Override
    public void mapPoints(float[] src, int srcPos, float[] dst, int dstPos, int count) {
        int mask = this.getType();
        if (mask == 0) {
            if (src != dst && count > 0) {
                System.arraycopy(src, srcPos, dst, dstPos, count << 1);
            }
        } else if (mask <= 1) {
            this.mapPoints1(src, srcPos, dst, dstPos, count);
        } else if (mask <= 3) {
            this.mapPoints2(src, srcPos, dst, dstPos, count);
        } else if (mask <= 7) {
            this.mapPoints4(src, srcPos, dst, dstPos, count);
        } else {
            this.mapPoints8(src, srcPos, dst, dstPos, count);
        }
    }

    private void mapPoints1(float[] src, int srcPos, float[] dst, int dstPos, int count) {
        float tx = this.m41;
        float ty = this.m42;
        for (int i = 0; i < count; ++i) {
            dst[dstPos] = src[srcPos] + tx;
            dst[dstPos + 1] = src[srcPos + 1] + ty;
            srcPos += 2;
            dstPos += 2;
        }
    }

    private void mapPoints2(float[] src, int srcPos, float[] dst, int dstPos, int count) {
        float sx = this.m11;
        float sy = this.m22;
        float tx = this.m41;
        float ty = this.m42;
        for (int i = 0; i < count; ++i) {
            dst[dstPos] = sx * src[srcPos] + tx;
            dst[dstPos + 1] = sy * src[srcPos + 1] + ty;
            srcPos += 2;
            dstPos += 2;
        }
    }

    private void mapPoints4(float[] src, int srcPos, float[] dst, int dstPos, int count) {
        float sx = this.m11;
        float sy = this.m22;
        float kx = this.m21;
        float ky = this.m12;
        float tx = this.m41;
        float ty = this.m42;
        for (int i = 0; i < count; ++i) {
            float p0 = src[srcPos];
            float p1 = src[srcPos + 1];
            float x = sx * p0 + kx * p1 + tx;
            float y = ky * p0 + sy * p1 + ty;
            dst[dstPos] = x;
            dst[dstPos + 1] = y;
            srcPos += 2;
            dstPos += 2;
        }
    }

    private void mapPoints8(float[] src, int srcPos, float[] dst, int dstPos, int count) {
        float m11 = this.m11;
        float m12 = this.m12;
        float m14 = this.m14;
        float m21 = this.m21;
        float m22 = this.m22;
        float m24 = this.m24;
        float m41 = this.m41;
        float m42 = this.m42;
        float m44 = this.m44;
        for (int i = 0; i < count; ++i) {
            float p0 = src[srcPos];
            float p1 = src[srcPos + 1];
            float x = m11 * p0 + m21 * p1 + m41;
            float y = m12 * p0 + m22 * p1 + m42;
            float w = m14 * p0 + m24 * p1 + m44;
            if (w != 0.0f) {
                w = 1.0f / w;
            }
            dst[dstPos] = x * w;
            dst[dstPos + 1] = y * w;
            srcPos += 2;
            dstPos += 2;
        }
    }

    @Override
    public float getMinScale() {
        float result;
        int mask = this.getType();
        if (mask == 0) {
            return 1.0f;
        }
        if ((mask & 8) != 0) {
            return -1.0f;
        }
        if ((mask & 4) == 0) {
            return Math.min(Math.abs(this.m11), Math.abs(this.m22));
        }
        float a = this.m11 * this.m11 + this.m12 * this.m12;
        float b = this.m11 * this.m21 + this.m22 * this.m12;
        float c = this.m21 * this.m21 + this.m22 * this.m22;
        if (MathUtil.isApproxZero(b)) {
            result = Math.min(a, c);
        } else {
            float amc = a - c;
            float x = (float)(Math.sqrt(amc * amc + 4.0f * b * b) * 0.5);
            result = (a + c) * 0.5f - x;
        }
        if (!Float.isFinite(result)) {
            return -1.0f;
        }
        return (float)Math.sqrt(Math.abs(result));
    }

    @Override
    public float getMaxScale() {
        float result;
        int mask = this.getType();
        if (mask == 0) {
            return 1.0f;
        }
        if ((mask & 8) != 0) {
            return -1.0f;
        }
        if ((mask & 4) == 0) {
            return Math.max(Math.abs(this.m11), Math.abs(this.m22));
        }
        float a = this.m11 * this.m11 + this.m12 * this.m12;
        float b = this.m11 * this.m21 + this.m22 * this.m12;
        float c = this.m21 * this.m21 + this.m22 * this.m22;
        if (MathUtil.isApproxZero(b)) {
            result = Math.max(a, c);
        } else {
            float amc = a - c;
            float x = (float)(Math.sqrt(amc * amc + 4.0f * b * b) * 0.5);
            result = (a + c) * 0.5f + x;
        }
        if (!Float.isFinite(result)) {
            return -1.0f;
        }
        return (float)Math.sqrt(Math.abs(result));
    }

    private static float computeMinScale(double m11, double m21, double m12, double m22) {
        double s1 = m11 * m11 + m21 * m21 + m12 * m12 + m22 * m22;
        double e = m11 * m11 + m21 * m21 - m12 * m12 - m22 * m22;
        double f = m11 * m12 + m21 * m22;
        double s2 = Math.sqrt(e * e + 4.0 * f * f);
        return (float)Math.sqrt(0.5 * (s1 - s2));
    }

    private static float computeMaxScale(double m11, double m21, double m12, double m22) {
        double s1 = m11 * m11 + m21 * m21 + m12 * m12 + m22 * m22;
        double e = m11 * m11 + m21 * m21 - m12 * m12 - m22 * m22;
        double f = m11 * m12 + m21 * m22;
        double s2 = Math.sqrt(e * e + 4.0 * f * f);
        return (float)Math.sqrt(0.5 * (s1 + s2));
    }

    private float computeMinScale(double px, double py) {
        double x = (double)this.m11 * px + (double)this.m21 * py + (double)this.m41;
        double y = (double)this.m12 * px + (double)this.m22 * py + (double)this.m42;
        double w = (double)this.m14 * px + (double)this.m24 * py + (double)this.m44;
        double dxdu = this.m11;
        double dxdv = this.m21;
        double dydu = this.m12;
        double dydv = this.m22;
        double dwdu = this.m14;
        double dwdv = this.m24;
        double invW2 = 1.0 / (w * w);
        double dfdu = (w * dxdu - x * dwdu) * invW2;
        double dfdv = (w * dxdv - x * dwdv) * invW2;
        double dgdu = (w * dydu - y * dwdu) * invW2;
        double dgdv = (w * dydv - y * dwdv) * invW2;
        return Matrix.computeMinScale(dfdu, dfdv, dgdu, dgdv);
    }

    @Override
    public float getMinScale(float px, float py) {
        if (!this.hasPerspective()) {
            return this.getMinScale();
        }
        return this.computeMinScale(px, py);
    }

    @Override
    public float getMaxScale(float px, float py) {
        if (!this.hasPerspective()) {
            return this.getMaxScale();
        }
        double x = this.m11 * px + this.m21 * py + this.m41;
        double y = this.m12 * px + this.m22 * py + this.m42;
        double w = this.m14 * px + this.m24 * py + this.m44;
        double dxdu = this.m11;
        double dxdv = this.m21;
        double dydu = this.m12;
        double dydv = this.m22;
        double dwdu = this.m14;
        double dwdv = this.m24;
        double invW2 = 1.0 / (w * w);
        double dfdu = (w * dxdu - x * dwdu) * invW2;
        double dfdv = (w * dxdv - x * dwdv) * invW2;
        double dgdu = (w * dydu - y * dwdu) * invW2;
        double dgdv = (w * dydv - y * dwdv) * invW2;
        return Matrix.computeMaxScale(dfdu, dfdv, dgdu, dgdv);
    }

    @Override
    public float differentialAreaScale(float px, float py) {
        double x = (double)this.m11 * (double)px + (double)this.m21 * (double)py + (double)this.m41;
        double y = (double)this.m12 * (double)px + (double)this.m22 * (double)py + (double)this.m42;
        double w = (double)this.m14 * (double)px + (double)this.m24 * (double)py + (double)this.m44;
        if (w <= (double)1.0E-5f) {
            return Float.POSITIVE_INFINITY;
        }
        double dxdu = this.m11;
        double dxdv = this.m21;
        double dydu = this.m12;
        double dydv = this.m22;
        double dwdu = this.m14;
        double dwdv = this.m24;
        double detJ = x * (dydu * dwdv - dwdu * dydv) + y * (dwdu * dxdv - dxdu * dwdv) + w * (dxdu * dydv - dydu * dxdv);
        double denom = 1.0 / w;
        denom = denom * denom * denom;
        return (float)Math.abs(detJ * denom);
    }

    @Override
    public float localAARadius(Rect2fc bounds) {
        return this.localAARadius(bounds.left(), bounds.top(), bounds.right(), bounds.bottom());
    }

    @Override
    public float localAARadius(float left, float top, float right, float bottom) {
        float min;
        if ((this.getType() & 8) == 0) {
            min = this.getMinScale();
        } else {
            float tl = this.computeMinScale(left, top);
            float tr = this.computeMinScale(right, top);
            float br = this.computeMinScale(right, bottom);
            float bl = this.computeMinScale(left, bottom);
            min = MathUtil.min(tl, tr, br, bl);
        }
        float aaRadius = 1.0f / min;
        if (Float.isFinite(aaRadius)) {
            return aaRadius;
        }
        return Float.POSITIVE_INFINITY;
    }

    public void setRectToRect(Rect2fc src, Rect2fc dst) {
        if (src.isEmpty()) {
            this.setIdentity();
            return;
        }
        if (dst.isEmpty()) {
            this.m11 = 0.0f;
            this.m12 = 0.0f;
            this.m14 = 0.0f;
            this.m21 = 0.0f;
            this.m22 = 0.0f;
            this.m24 = 0.0f;
            this.m41 = 0.0f;
            this.m42 = 0.0f;
            this.m44 = 1.0f;
            this.mTypeMask = 2;
        } else {
            float sx = dst.width() / src.width();
            float sy = dst.height() / src.height();
            float tx = dst.left() - src.left() * sx;
            float ty = dst.top() - src.top() * sy;
            this.setScaleTranslate(sx, sy, tx, ty);
        }
    }

    public void normalizePerspective() {
        if (this.m44 != 1.0f && this.m14 == 0.0f && this.m24 == 0.0f) {
            if (this.m44 != 0.0f) {
                double inv = 1.0 / (double)this.m44;
                this.m11 = (float)((double)this.m11 * inv);
                this.m12 = (float)((double)this.m12 * inv);
                this.m21 = (float)((double)this.m21 * inv);
                this.m22 = (float)((double)this.m22 * inv);
                this.m41 = (float)((double)this.m41 * inv);
                this.m42 = (float)((double)this.m42 * inv);
                this.m44 = 1.0f;
            }
            this.mTypeMask = 128;
        }
    }

    @Override
    public boolean isFinite() {
        return MathUtil.isFinite(this.m11, this.m12, this.m14, this.m21, this.m22, this.m24, this.m41, this.m42, this.m44);
    }

    private static int floatTo2sCompliment(float x) {
        int bits = Float.floatToRawIntBits(x);
        if (bits < 0) {
            return -(bits & Integer.MAX_VALUE);
        }
        return bits;
    }

    private int computeTypeMask() {
        int mask = 0;
        if (this.m14 != 0.0f || this.m24 != 0.0f || this.m44 != 1.0f) {
            return 15;
        }
        if (this.m41 != 0.0f || this.m42 != 0.0f) {
            mask |= 1;
        }
        int m00 = Matrix.floatTo2sCompliment(this.m11);
        int m01 = Matrix.floatTo2sCompliment(this.m21);
        int m10 = Matrix.floatTo2sCompliment(this.m12);
        int m11 = Matrix.floatTo2sCompliment(this.m22);
        if ((m01 | m10) != 0) {
            mask |= 6;
            m01 = m01 != 0 ? 1 : 0;
            m10 = m10 != 0 ? 1 : 0;
            int dp0 = (m00 | m11) == 0 ? 1 : 0;
            int ds1 = m01 & m10;
            mask |= (dp0 & ds1) << 4;
        } else {
            if ((m00 ^ 0x3F800000 | m11 ^ 0x3F800000) != 0) {
                mask |= 2;
            }
            m00 = m00 != 0 ? 1 : 0;
            m11 = m11 != 0 ? 1 : 0;
            mask |= (m00 & m11) << 4;
        }
        return mask;
    }

    private int computePerspectiveTypeMask() {
        if (this.m14 != 0.0f || this.m24 != 0.0f || this.m44 != 1.0f) {
            return 15;
        }
        return 192;
    }

    public boolean isApproxEqual(@Nonnull Matrix m) {
        return MathUtil.isApproxEqual(this.m11, m.m11) && MathUtil.isApproxEqual(this.m12, m.m12) && MathUtil.isApproxEqual(this.m14, m.m14) && MathUtil.isApproxEqual(this.m21, m.m21) && MathUtil.isApproxEqual(this.m22, m.m22) && MathUtil.isApproxEqual(this.m24, m.m24) && MathUtil.isApproxEqual(this.m41, m.m41) && MathUtil.isApproxEqual(this.m42, m.m42) && MathUtil.isApproxEqual(this.m44, m.m44);
    }

    public static boolean equals(@Nonnull Matrixc a, @Nonnull Matrixc b) {
        return a.m11() == b.m11() && a.m12() == b.m12() && a.m14() == b.m14() && a.m21() == b.m21() && a.m22() == b.m22() && a.m24() == b.m24() && a.m41() == b.m41() && a.m42() == b.m42() && a.m44() == b.m44();
    }

    @Override
    public int hashCode() {
        int result = this.m11 != 0.0f ? Float.floatToIntBits(this.m11) : 0;
        result = 31 * result + (this.m12 != 0.0f ? Float.floatToIntBits(this.m12) : 0);
        result = 31 * result + (this.m14 != 0.0f ? Float.floatToIntBits(this.m14) : 0);
        result = 31 * result + (this.m21 != 0.0f ? Float.floatToIntBits(this.m21) : 0);
        result = 31 * result + (this.m22 != 0.0f ? Float.floatToIntBits(this.m22) : 0);
        result = 31 * result + (this.m24 != 0.0f ? Float.floatToIntBits(this.m24) : 0);
        result = 31 * result + (this.m41 != 0.0f ? Float.floatToIntBits(this.m41) : 0);
        result = 31 * result + (this.m42 != 0.0f ? Float.floatToIntBits(this.m42) : 0);
        result = 31 * result + (this.m44 != 0.0f ? Float.floatToIntBits(this.m44) : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Matrixc)) {
            return false;
        }
        Matrixc m = (Matrixc)o;
        return Matrix.equals(this, m);
    }

    @Override
    public String toString() {
        return String.format("Matrix:\n%10.6f %10.6f %10.6f\n%10.6f %10.6f %10.6f\n%10.6f %10.6f %10.6f", Float.valueOf(this.m11), Float.valueOf(this.m12), Float.valueOf(this.m14), Float.valueOf(this.m21), Float.valueOf(this.m22), Float.valueOf(this.m24), Float.valueOf(this.m41), Float.valueOf(this.m42), Float.valueOf(this.m44));
    }

    @Override
    @Nonnull
    public Matrix clone() {
        try {
            return (Matrix)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

